#include <iostream>
#include <string>
#include <vector>

using namespace std;

class Player;
class Map;

class Room
{
public:
    Room(string n, string desc);
    void pRoomName();
    void pRoomDesc();
    void getRoomItems();
    void setRoomItems(string items);
    void pickupRoomItems(Player& player);

    Room* pEast;
    Room* pWest;
    Room* pNorth;
    Room* pSouth;

    bool canEnter(Player& player);

    string getRoomName() const {
        return rName;
    }

private:
    string rName;
    string rDesc;
    vector<string> roomInventory;
};

class Map
{
public:
    Map();
    ~Map();

    Room* mStart;
};

class Player
{
public:
    Player();
    Room* pLoc;

    vector<string> pInventory;
    bool WardensKey;

    void getInventory();
};

void Room::setRoomItems(string items)
{
    roomInventory.push_back(items);
}

void Room::getRoomItems()
{
    vector<string>::iterator iter;

    if (roomInventory.size() != 0)
    {
        cout << "\nThe room's items:" << endl;
        for (iter = roomInventory.begin(); iter != roomInventory.end(); ++iter)
        {
            cout << *iter << endl;
        }
    }
    else
        cout << "\nRoom inventory is empty!" << endl;
}

void Room::pickupRoomItems(Player& player) {
    if (roomInventory.size() != 0) {
        cout << "You picked up " << roomInventory.front() << endl;
        player.pInventory.push_back(roomInventory.front());

        if (roomInventory.front() == "Warden's Key") {
            player.WardensKey = true;
        }

        roomInventory.erase(roomInventory.begin());
    }
    else {
        cout << "There is nothing to pick up in this room." << endl;
    }
}

Room::Room(string n, string desc)
{
    rName = n;
    rDesc = desc;
}

void Room::pRoomName()
{
    cout << rName << endl;
}

void Room::pRoomDesc()
{
    cout << rDesc << endl;

    getRoomItems();
}

Map::~Map()
{
    delete mStart;
}

bool Room::canEnter(Player& player) {
 
    if (rName == "Breakroom") {
        if (!player.WardensKey) {
            cout << "You need the Warden's Key to enter the Breakroom!" << endl;
            return false;
        }
    }

    return true;
}

Map::Map()
{
    Room* p1 = new Room("Cell Block 1", "You see all of the prison cells open.");
    mStart = p1;

    Room* p2 = new Room("Laundry Room", "You see a lot of unfinished laundry, including some guard uniforms.");
    p2->setRoomItems("Uniforms");

    Room* p3 = new Room("Cafeteria", "There is no more food in the cafeteria.");

    Room* p4 = new Room("Doctors Office", "You see all of the prisoner's medication scattered throughout the room. You also see a valve.");
    p4->setRoomItems("Control Valve");

    Room* p5 = new Room("Rooftop", "You see a broken plane with missing parts.");

    Room* p6 = new Room("Wardens Office", "You see that the office had been destroyed and ransacked.");
    p6->setRoomItems("Warden's Key");

    Room* p7 = new Room("Cell Block 2", "This is the main cell block and all of the prison cells are open.");

    Room* p8 = new Room("Showers", "The ground is dry and shows no sign of recent activity. You see some rope on the ground.");
    p8->setRoomItems("Rigging");

    Room* p9 = new Room("Breakroom", "The breakroom is unlocked and empty.");

    Room* p10 = new Room("Electrical Room", "The electrical room is not working and the power is turned off. You see an engine in the corner of the room.");
    p10->setRoomItems("Engine");

    Room* p11 = new Room("Docks", "You see that there are no boats at the dock.");

    Room* p12 = new Room("Boathouse", "The boathouse has been ransacked, but there are some tanks.");
    p12->setRoomItems("Tanks");

    p1->pNorth = p1;
    p1->pEast = p3;
    p1->pSouth = p7;
    p1->pWest = p2;

    p2->pNorth = p2;
    p2->pEast = p1;
    p2->pSouth = p2;
    p2->pWest = p2;

    p3->pNorth = p4;
    p3->pEast = p3;
    p3->pSouth = p3;
    p3->pWest = p1;

    p4->pNorth = p4;
    p4->pEast = p6;
    p4->pSouth = p3;
    p4->pWest = p5;

    p5->pNorth = p5;
    p5->pEast = p4;
    p5->pSouth = p5;
    p5->pWest = p5;

    p6->pNorth = p6;
    p6->pEast = p6;
    p6->pSouth = p6;
    p6->pWest = p4;

    p7->pNorth = p1;
    p7->pEast = p7;
    p7->pSouth = p9;
    p7->pWest = p8;

    p8->pNorth = p8;
    p8->pEast = p7;
    p8->pSouth = p8;
    p8->pWest = p8;

    p9->pNorth = p7;
    p9->pEast = p10;
    p9->pSouth = p9;
    p9->pWest = p9;

    p10->pNorth = p10;
    p10->pEast = p11;
    p10->pSouth = p10;
    p10->pWest = p9;

    p11->pNorth = p12;
    p11->pEast = p11;
    p11->pSouth = p11;
    p11->pWest = p10;

    p12->pNorth = p12;
    p12->pEast = p12;
    p12->pSouth = p11;
    p12->pWest = p12;
}

void Player::getInventory()
{
    vector<string>::iterator iter;

    if (pInventory.size() != 0)
    {
        cout << "\nInventory list:" << endl;
        for (iter = pInventory.begin(); iter != pInventory.end(); ++iter)
        {
            cout << *iter << endl;
        }
    }
    else
        cout << "\nInventory is empty!" << endl;
}

Player::Player()
{
    pLoc = nullptr;
}


void intro()
{
    cout << "You wake up in an unlocked prison cell not knowing how you ended up here." << endl;
    cout << "You walk out of your cell and see no prisoners or guards." << endl << endl;
}

void help()
{
    cout << "Controls:" << endl;
    cout << " N - Move North" << endl;
    cout << " E - Move East" << endl;
    cout << " S - Move South" << endl;
    cout << " W - Move West" << endl;
    cout << " I - Inventory" << endl;
    cout << " P - Pick Up" << endl;
    cout << " H - Help" << endl;
    cout << " Q - Quit" << endl;
    cout << endl;
}

void end()
{
    cout << "You found all the plane parts and head to the rooftop." << endl;
    cout << "You attach all the parts to the plane and take off." << endl;
    cout << "Enter Q to Quit" << endl;
}

int main()
{
    Map GameMap;

    char com = 'a';

    Player Player1;
    Player1.WardensKey = false;

    help();
    intro();

    Player1.pLoc = GameMap.mStart;

    Player1.pLoc->pRoomName();
    Player1.pLoc->pRoomDesc();

    while (com != 'Q') {
        cout << endl;
        cout << "Enter command: ";
        cin >> com;
        com = toupper(com);
        cout << endl;

        if (com == 'N' || com == 'E' || com == 'S' || com == 'W') {
 
            Room* previousLoc = Player1.pLoc;

            if (com == 'N' && Player1.pLoc != Player1.pLoc->pNorth) {
                Player1.pLoc = Player1.pLoc->pNorth;
            }
            else if (com == 'E' && Player1.pLoc != Player1.pLoc->pEast) {
                Player1.pLoc = Player1.pLoc->pEast;
            }
            else if (com == 'S' && Player1.pLoc != Player1.pLoc->pSouth) {
                Player1.pLoc = Player1.pLoc->pSouth;
            }
            else if (com == 'W' && Player1.pLoc != Player1.pLoc->pWest) {
                Player1.pLoc = Player1.pLoc->pWest;
            }
            else {
                cout << "You cannot go this way" << endl;
                continue;
            }

            if (!Player1.pLoc->canEnter(Player1)) {
                Player1.pLoc = previousLoc;
            }

            Player1.pLoc->pRoomName();
            Player1.pLoc->pRoomDesc();

            if (Player1.pLoc->getRoomName() == "Rooftop" && Player1.pInventory.size() == 6) {
                cout << endl;
                end();
                break;
            }
        }
        else if (com == 'I') {
            Player1.getInventory();
            Player1.pLoc->getRoomItems();
        }
        else if (com == 'H') {
            help();
        }
        else if (com == 'P') {
            Player1.pLoc->pickupRoomItems(Player1);
        }
        else if (com == 'Q') {
            break;
        }
        else {
            cout << "\nInvalid command! " << endl;
        }
    }

    system("pause");
    return 0;
}


